#include "enemy.h"
#include "global.h"
#include <cmath>
#include <vector>
 
enemy::enemy(int typeTo)
{
	type = typeTo;
	setup();
}

enemy::enemy()
{
	type = rand() % 5;
	setup();
}

void enemy::damage()
{
	hp--;
}

void enemy::move(float v, bool fix)
{
	bool rotate = false;
	float deltaX = timeAdjuster * v * cos((double)angToRad(a - 64.0f));
	float deltaY = timeAdjuster * v * sin((double)angToRad(a - 64.0f));
				
	x = x + deltaX;
	if((collisionMap[(int)x / 8][(int)y / 8])||(checkEnemies(x, y, 3.0f, this)))
	{
		x = x - deltaX;
		rotate = true;
	}
				
	y = y + deltaY;
	if((collisionMap[(int)x / 8][(int)y / 8])||(checkEnemies(x, y, 3.0f, this)))
	{
		y = y - deltaY;
		rotate = true;
	}
	if((rotate)&&(fix))
		a = a + 64.0f;
}

void enemy::update()
{
	switch(type)
	{
		case EnemyTypeContainer:
		{
			//containers will kind of randomly move about, not very smart
			int randNum = rand() % 32000;
			float moveAngle = (randNum / 1000.0f) - 16.0f;
			a += moveAngle;
			move(0.1f);
			break;
		}
		case EnemyTypeShooter:
		{
			//stationary, but will take shots at the player, randomly of course
			//set angle to aim at player
			a = getAngle(x, y, PlayerX, PlayerY);
			int randNum = rand() % (int)(400.0f / timeAdjuster);
			if(randNum == 0)
			{
				//fire
				bullet newBull(x, y, a);
				enemyBullets.push_back(newBull);
			}
			break;
		}
		case EnemyTypeRoamer:
		{
			//moves directly at the player, will get stuck on walls but that will just have to happen
			//I really don't want to have path finding code, maybe though...
			a = getAngle(x, y, PlayerX, PlayerY);
			move(0.1f, false);
			break;
		}
		
	}
}

void enemy::draw(BITMAP *to, BITMAP *me)
{
	if(type == EnemyTypeContainer)
		rotate_sprite(to, me, ((int)x) - (me->w/2), ((int)y) - (me->h/2), ftofix(0.0f));
	else
		rotate_sprite(to, me, ((int)x) - (me->w/2), ((int)y) - (me->h/2), ftofix(a));
}

void enemy::setup()
{
	//find a free location for an enemy
	//start my finding all empty locations
	std::vector<int> Xes;
	std::vector<int> Yes;
	for(int x2 = 0; x2 < 20; x2++)
	{
		for(int y2 = 0; y2 < 15; y2++)
		{
			if((!collisionMap[x2][y2])&&(!checkEnemies(x2 * 8.0f + 4.0f, y2 * 8.0f + 4.0f, 4.0f)))
			{
				Xes.push_back(x2);
				Yes.push_back(y2);
			}
		}
	}
	
	int which = rand() % Xes.size();
	x = Xes[which] * 8.0f;
	y = Yes[which] * 8.0f;
	
	hp = 10 - type;
	
	which = rand() % 2560;
	a = which / 10.0f;
}
